package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

@RequiredArgsConstructor(staticName = "of")
public class FindByIpAndTypeInDayQuery implements ExampleQuery {

    private final String ip;
    private final AuthSessionEntity.Type type;

    @Override
    public Criteria getCriteria() {
        var time = Instant.now().minus(1, ChronoUnit.HOURS);
        return new Criteria().andOperator(
                Criteria.where("ipV4").is(ip),
                Criteria.where("type").is(type),
                Criteria.where("createdAt").gte(time),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
