/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.RefreshTokenRepository;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.RefreshTokenFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.RefreshTokenDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.RefreshTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.DeactivateAllTokensByCredentialQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.ExpireRefreshTokenQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindAllActiveByUserIdQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindRefreshTokensQuery;

@Repository
public class MongoRefreshTokenRepository
extends AbstractMongoSafeDeleteRepository<String, RefreshTokenEntity, RefreshTokenDoc, RefreshTokenFilters>
implements RefreshTokenRepository {
    public MongoRefreshTokenRepository(RefreshTokenDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RefreshTokenDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public void expireRefreshToken(RefreshTokenEntity refreshTokenEntity) {
        ExpireRefreshTokenQuery expireRefreshTokenQuery = ExpireRefreshTokenQuery.of((String)refreshTokenEntity.getId());
        this.mongoTemplate.updateFirst(expireRefreshTokenQuery.getQuery(), (UpdateDefinition)expireRefreshTokenQuery.getUpdate(), RefreshTokenDoc.class);
    }

    public List<RefreshTokenEntity> findAllActiveByUserId(String userId) {
        return this.mongoTemplate.find(FindAllActiveByUserIdQuery.of(userId).getQuery(), RefreshTokenDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList());
    }

    public void deactivateByCredentialId(String credentialId) {
        DeactivateAllTokensByCredentialQuery query = DeactivateAllTokensByCredentialQuery.of(credentialId);
        this.mongoTemplate.update(this.documentClass).matching(query.getQuery()).apply((UpdateDefinition)query.getUpdate()).all();
    }

    protected AbstractExampleQuery getSearchQuery(RefreshTokenFilters filters) {
        return new FindRefreshTokensQuery(filters);
    }
}

