/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import com.rcore.domain.commons.port.dto.SearchFilters;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.role.port.filters.RoleFilters;

public class FindRoleWithFiltersQuery
extends AbstractExampleQuery {
    private final RoleFilters filters;

    public FindRoleWithFiltersQuery(RoleFilters filters) {
        super((SearchFilters)filters);
        this.filters = filters;
    }

    public Criteria getCriteria() {
        Criteria res = new Criteria();
        HashSet<Criteria> criteriaSet = new HashSet<Criteria>();
        IsDeletedCriteria.filterCriteria((Boolean)this.filters.getDeleted()).ifPresent(criteriaSet::add);
        if (StringUtils.hasText((String)this.filters.getQuery())) {
            criteriaSet.add(MongoQueryUtils.generateQueryRegEXCriteria((String)this.filters.getQuery(), (String[])new String[]{"name", "code"}));
        }
        if (this.filters.getIsRegistrationAllowed() != null) {
            criteriaSet.add(Criteria.where((String)"isRegistrationAllowed").is((Object)this.filters.getIsRegistrationAllowed()));
        }
        if (this.filters.getAccessIds() != null && !this.filters.getAccessIds().isEmpty()) {
            criteriaSet.add(Criteria.where((String)"accessIds").all((Collection)this.filters.getAccessIds()));
        }
        if (!criteriaSet.isEmpty()) {
            res = new Criteria().andOperator((Criteria[])criteriaSet.toArray(Criteria[]::new));
        }
        return res;
    }
}

