/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.CollectionNameUtils;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.domain.role.port.RoleRepository;
import ru.foodtechlab.lib.auth.service.domain.role.port.filters.RoleFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.mapper.RoleDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.DeleteAccessFromRolesQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.FindByCodeQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.FindRoleWithFiltersQuery;

@Repository
public class MongoRoleRepository
extends AbstractMongoSafeDeleteRepository<String, RoleEntity, RoleDoc, RoleFilters>
implements RoleRepository {
    public MongoRoleRepository(RoleDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RoleDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public Optional<RoleEntity> findByCode(String code) {
        return Optional.ofNullable((RoleDoc)((Object)this.mongoTemplate.findOne(FindByCodeQuery.of(code).getQuery(), RoleDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    protected AbstractExampleQuery getSearchQuery(RoleFilters filters) {
        return new FindRoleWithFiltersQuery(filters);
    }

    public void deleteRoleAccessFromRole(String accessId) {
        DeleteAccessFromRolesQuery query = DeleteAccessFromRolesQuery.of(accessId);
        this.mongoTemplate.update(this.documentClass).matching(query.getQuery()).apply((UpdateDefinition)query.getUpdate()).all();
    }

    public static String getCollectionName() {
        return CollectionNameUtils.getCollectionName(RoleDoc.class);
    }
}

