/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import com.rcore.domain.commons.port.dto.SearchFilters;
import java.util.HashSet;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.credential.port.filters.CredentialFilters;

public class FindCredentialWithFiltersQuery
extends AbstractExampleQuery {
    private final CredentialFilters filters;

    public FindCredentialWithFiltersQuery(CredentialFilters filters) {
        super((SearchFilters)filters);
        this.filters = filters;
    }

    public Criteria getCriteria() {
        HashSet<Criteria> criteriaSet = new HashSet<Criteria>();
        IsDeletedCriteria.filterCriteria((Boolean)this.filters.getDeleted()).ifPresent(criteriaSet::add);
        if (this.filters.getBlocked() != null) {
            criteriaSet.add(Criteria.where((String)"isBlocked").is((Object)this.filters.getBlocked()));
        }
        if (this.filters.getRoleIds() != null && !this.filters.getRoleIds().isEmpty()) {
            Criteria allRoles = new Criteria().andOperator((Criteria[])this.filters.getRoleIds().stream().map(r -> Criteria.where((String)"roles").elemMatch(Criteria.where((String)"role.$id").is((Object)new ObjectId(r)))).toArray(Criteria[]::new));
            criteriaSet.add(new Criteria().andOperator(new Criteria[]{allRoles}));
        }
        if (this.filters.getConfirmationCodeType() != null) {
            criteriaSet.add(Criteria.where((String)"confirmationCodeType").is((Object)this.filters.getConfirmationCodeType()));
        }
        if (this.filters.getConfirmationCodeDestinationType() != null) {
            criteriaSet.add(Criteria.where((String)"confirmationCodeDestinationType").is((Object)this.filters.getConfirmationCodeDestinationType()));
        }
        if (StringUtils.hasText((String)this.filters.getQuery())) {
            criteriaSet.add(MongoQueryUtils.generateQueryRegEXCriteria((String)this.filters.getQuery(), (String[])new String[]{"username", "phoneNumber.value", "email.value"}));
        }
        if (!criteriaSet.isEmpty()) {
            return new Criteria().andOperator((Criteria[])criteriaSet.toArray(Criteria[]::new));
        }
        return new Criteria();
    }
}

