/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import com.rcore.domain.commons.port.dto.SearchFilters;
import java.util.ArrayList;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.port.filter.AuthorizationSessionFilters;

public class FindWithFiltersQuery
extends AbstractExampleQuery {
    private final AuthorizationSessionFilters filters;

    public FindWithFiltersQuery(AuthorizationSessionFilters filters) {
        super((SearchFilters)filters);
        this.filters = filters;
    }

    public Criteria getCriteria() {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        if (this.filters.getCredentialId() != null) {
            criteriaList.add(Criteria.where((String)"credential.$id").is((Object)new ObjectId(this.filters.getCredentialId())));
        }
        if (this.filters.getConfirmationCodeType() != null) {
            criteriaList.add(Criteria.where((String)"confirmationCodeType").is((Object)this.filters.getConfirmationCodeType()));
        }
        IsDeletedCriteria.filterCriteria((Boolean)this.filters.getDeleted()).ifPresent(criteriaList::add);
        if (this.filters.getLoginType() != null) {
            criteriaList.add(Criteria.where((String)"loginType").is((Object)this.filters.getLoginType()));
        }
        if (this.filters.getStatus() != null) {
            criteriaList.add(Criteria.where((String)"status").is((Object)this.filters.getStatus()));
        }
        if (this.filters.getType() != null) {
            criteriaList.add(Criteria.where((String)"type").is((Object)this.filters.getType()));
        }
        if (this.filters.getIsRegistrationAllowed() != null) {
            criteriaList.add(Criteria.where((String)"isRegistrationAllowed").is((Object)this.filters.getIsRegistrationAllowed()));
        }
        if (this.filters.getDateFrom() != null) {
            criteriaList.add(Criteria.where((String)"createdAt").gte((Object)this.filters.getDateFrom()));
        }
        if (this.filters.getDateTo() != null) {
            criteriaList.add(Criteria.where((String)"createdAt").lte((Object)this.filters.getDateTo()));
        }
        if (StringUtils.hasText((String)this.filters.getQuery())) {
            criteriaList.add(MongoQueryUtils.generateQueryRegEXCriteria((String)this.filters.getQuery(), (String[])new String[]{"email", "username", "phoneNumber"}));
        }
        return !criteriaList.isEmpty() ? new Criteria().andOperator((Criteria[])criteriaList.toArray(Criteria[]::new)) : new Criteria();
    }
}

