/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.auth.port.AuthorizationSessionRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.port.filter.AuthorizationSessionFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.mapper.AuthorizationSessionDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model.AuthSessionDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindByClientInfoInDayQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindByDeviceIdAndTypeInDayQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindByIpAndTypeInDayQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindByLoginDetailsAndTypeInDayQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindByLoginDetailsInDayQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindPendingConfirmationByLoginDetailsQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.FindWithFiltersQuery;

@Repository
public class MongoAuthorizationSessionRepository
extends AbstractMongoSafeDeleteRepository<String, AuthSessionEntity, AuthSessionDoc, AuthorizationSessionFilters>
implements AuthorizationSessionRepository {
    public MongoAuthorizationSessionRepository(AuthorizationSessionDocMapper mapper, MongoTemplate mongoTemplate) {
        super(AuthSessionDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public Optional<AuthSessionEntity> findPendingByAuthData(LoginDetails loginDetails, ClientInfo clientInfo) {
        Query query = FindPendingConfirmationByLoginDetailsQuery.of(loginDetails, clientInfo.getDeviceId()).getQuery();
        return Optional.ofNullable((AuthSessionDoc)((Object)this.mongoTemplate.findOne(query, AuthSessionDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    public Long countSessionsByDeviceTokenAndTypeInDay(String deviceId, AuthSessionEntity.Type type) {
        Query query = FindByDeviceIdAndTypeInDayQuery.of(deviceId, type).getQuery();
        return this.mongoTemplate.count(query, AuthSessionDoc.class);
    }

    public Long countSessionsByIpAndTypeInDay(String ip, AuthSessionEntity.Type type) {
        Query query = FindByIpAndTypeInDayQuery.of(ip, type).getQuery();
        return this.mongoTemplate.count(query, AuthSessionDoc.class);
    }

    public Long countByLoginDetailsAndTypeInHours(LoginDetails loginDetails, AuthSessionEntity.Type type) {
        Query query = FindByLoginDetailsAndTypeInDayQuery.of(loginDetails, type).getQuery();
        return this.mongoTemplate.count(query, AuthSessionDoc.class);
    }

    protected AbstractExampleQuery getSearchQuery(AuthorizationSessionFilters filters) {
        return new FindWithFiltersQuery(filters);
    }

    public List<AuthSessionEntity> findByClientInfoInDay(ClientInfo clientInfo) {
        Query query = FindByClientInfoInDayQuery.of(clientInfo).getQuery();
        return this.mongoTemplate.find(query, AuthSessionDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList());
    }

    public List<AuthSessionEntity> findByLoginDetailsInDay(LoginDetails loginDetails) {
        Query query = FindByLoginDetailsInDayQuery.of(loginDetails).getQuery();
        return this.mongoTemplate.find(query, AuthSessionDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList());
    }

    public void incrementAttempts(String authSessionId) {
    }
}

