/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import java.util.Optional;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.auth.port.AuthorizationSessionIdGenerator;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.CredentialEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.PhoneNumber;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.domain.token.entity.AccessTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model.AuthSessionDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.mapper.CredentialDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.mapper.RoleDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.AccessTokenDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.RefreshTokenDocMapper;

@Component
public class AuthorizationSessionDocMapper
implements ExampleDataMapper<AuthSessionEntity, AuthSessionDoc> {
    private final AuthorizationSessionIdGenerator<ObjectId> authorizationSessionIdGenerator;
    private final CredentialDocMapper credentialDocMapper;
    private final RoleDocMapper roleDocMapper;
    private final RefreshTokenDocMapper refreshTokenDocMapper;
    private final AccessTokenDocMapper accessTokenDocMapper;

    public AuthSessionEntity inverseMap(AuthSessionDoc doc) {
        return ((AuthSessionEntity.AuthSessionEntityBuilder)((AuthSessionEntity.AuthSessionEntityBuilder)((AuthSessionEntity.AuthSessionEntityBuilder)AuthSessionEntity.builder().id((Object)doc.getId().toString())).createdAt(doc.getCreatedAt())).updatedAt(doc.getUpdatedAt())).isDeleted(doc.isDeleted()).clientInfo(ClientInfo.builder().deviceId(doc.getDeviceId()).ip(doc.getIpV4()).application((String)Optional.ofNullable(doc.getApplicationDetails()).map(AuthSessionDoc.ApplicationDetails::getName).orElse(null)).versionName((String)Optional.ofNullable(doc.getApplicationDetails()).map(AuthSessionDoc.ApplicationDetails::getVersionName).orElse(null)).platform((String)Optional.ofNullable(doc.getApplicationDetails()).map(AuthSessionDoc.ApplicationDetails::getPlatform).orElse(null)).build()).loginDetails(LoginDetails.builder().email(doc.getEmail()).username(doc.getUsername()).phoneNumber((PhoneNumber)Optional.ofNullable(doc.getPhoneNumber()).map((? super T p) -> new PhoneNumber(doc.getPhoneNumber(), doc.getIsoTwoLetterCountryCode())).orElse(null)).build()).loginType(doc.getLoginType()).errors(doc.getErrors()).ttl(doc.getTtl()).expiredAt(doc.getExpireAt()).confirmationCodeType(doc.getConfirmationCodeType()).isRegistrationAllowed(doc.getIsRegistrationAllowed().booleanValue()).authSessionLoginInitAttempts(doc.getAuthSessionLoginInitAttempts()).status(doc.getStatus()).type(doc.getType()).authSessionLoginConfirmAttemptsLimit(doc.getAuthSessionLoginConfirmAttemptsLimit()).authSessionLoginConfirmAttempts(doc.getAuthSessionLoginConfirmAttempts()).credential((CredentialEntity)Optional.ofNullable(doc.getCredential()).map(this.credentialDocMapper::inverseMap).orElse(null)).targetRole((RoleEntity)Optional.ofNullable(doc.getRole()).map(this.roleDocMapper::inverseMap).orElse(null)).accessToken((AccessTokenEntity)Optional.ofNullable(doc.getAccessToken()).map(this.accessTokenDocMapper::inverseMap).orElse(null)).refreshToken((RefreshTokenEntity)Optional.ofNullable(doc.getRefreshToken()).map(this.refreshTokenDocMapper::inverseMap).orElse(null)).version(doc.getVersion()).build();
    }

    public AuthSessionDoc map(AuthSessionEntity entity) {
        return ((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((Object)((AuthSessionDoc.AuthSessionDocBuilder)((AuthSessionDoc.AuthSessionDocBuilder)((AuthSessionDoc.AuthSessionDocBuilder)((AuthSessionDoc.AuthSessionDocBuilder)AuthSessionDoc.builder().id((ObjectId)this.authorizationSessionIdGenerator.parse((String)entity.getId()))).createdAt(entity.getCreatedAt())).updatedAt(entity.getUpdatedAt())).deleted(entity.isDeleted())).loginType(entity.getLoginType()))).errors(entity.getErrors()))).ttl(entity.getTtl()))).authSessionLoginInitAttempts(entity.getAuthSessionLoginInitAttempts()))).authSessionLoginConfirmAttemptsLimit(entity.getAuthSessionLoginConfirmAttemptsLimit()))).authSessionLoginConfirmAttempts(entity.getAuthSessionLoginConfirmAttempts()))).expireAt(entity.getExpiredAt()))).confirmationCodeType(entity.getConfirmationCodeType()))).isRegistrationAllowed(entity.isRegistrationAllowed()))).status(entity.getStatus()))).type(entity.getType()))).email(entity.getLoginDetails().getEmail()))).phoneNumber(Optional.ofNullable(entity.getLoginDetails().getPhoneNumber()).map(PhoneNumber::getValue).orElse(null)))).isoTwoLetterCountryCode(Optional.ofNullable(entity.getLoginDetails().getPhoneNumber()).map(PhoneNumber::getIsoTwoLetterCountryCode).orElse(null)))).username(entity.getLoginDetails().getUsername()))).credential(Optional.ofNullable(entity.getCredential()).map(this.credentialDocMapper::map).orElse(null)))).role(Optional.ofNullable(entity.getTargetRole()).map(this.roleDocMapper::map).orElse(null)))).deviceId(Optional.ofNullable(entity.getClientInfo()).map(ClientInfo::getDeviceId).orElse(null)))).ipV4(Optional.ofNullable(entity.getClientInfo()).map(ClientInfo::getIp).orElse(null)))).applicationDetails(Optional.ofNullable(entity.getClientInfo()).map((? super T c) -> new AuthSessionDoc.ApplicationDetails(c.getApplication(), c.getPlatform(), c.getVersionName())).orElse(null)))).accessToken(Optional.ofNullable(entity.getAccessToken()).map(this.accessTokenDocMapper::map).orElse(null)))).refreshToken(Optional.ofNullable(entity.getRefreshToken()).map(this.refreshTokenDocMapper::map).orElse(null)))).version(entity.getVersion()))).build();
    }

    public AuthorizationSessionDocMapper(AuthorizationSessionIdGenerator<ObjectId> authorizationSessionIdGenerator, CredentialDocMapper credentialDocMapper, RoleDocMapper roleDocMapper, RefreshTokenDocMapper refreshTokenDocMapper, AccessTokenDocMapper accessTokenDocMapper) {
        this.authorizationSessionIdGenerator = authorizationSessionIdGenerator;
        this.credentialDocMapper = credentialDocMapper;
        this.roleDocMapper = roleDocMapper;
        this.refreshTokenDocMapper = refreshTokenDocMapper;
        this.accessTokenDocMapper = accessTokenDocMapper;
    }
}

