package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.RefreshTokenFilters;

import java.util.HashSet;
import java.util.Set;

public class FindRefreshTokensQuery extends AbstractExampleQuery {

    private final RefreshTokenFilters filters;

    public FindRefreshTokensQuery(RefreshTokenFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        Set<Criteria> criteriaSet = new HashSet<>(3);

        IsDeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaSet::add);

        if (filters.getCredentialId() != null)
            criteriaSet.add(Criteria.where("credential.$id").is(new ObjectId(filters.getCredentialId())));

        if (filters.getStatus() != null)
            criteriaSet.add(Criteria.where("status").is(filters.getStatus()));

        if (criteriaSet.isEmpty())
            return new Criteria();
        else
            return new Criteria().andOperator(criteriaSet.toArray(Criteria[]::new));
    }

    @Override
    public Query getQuery() {
        return Query.query(getCriteria());
    }
}
