package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractModifyQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;

@RequiredArgsConstructor(staticName = "of")
public class DeactivateAllAccessTokenByRefreshTokenIdQuery extends AbstractModifyQuery {

    private final String refreshTokenId;

    @Override
    public Update getUpdate() {
        return Update.update("status", RefreshTokenEntity.Status.INACTIVE);
    }

    @Override
    public FindAndModifyOptions getModifyOptions() {
        return FindAndModifyOptions.options().returnNew(true);
    }

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("createByRefreshTokenId").is(refreshTokenId),
                Criteria.where("status").ne(RefreshTokenEntity.Status.EXPIRED),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
