package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.RefreshTokenIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.mapper.CredentialDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.RefreshTokenDoc;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class RefreshTokenDocMapper implements ExampleDataMapper<RefreshTokenEntity, RefreshTokenDoc> {

    private final RefreshTokenIdGenerator<ObjectId> idGenerator;
    private final CredentialDocMapper credentialDocMapper;

    @Override
    public RefreshTokenDoc map(RefreshTokenEntity refreshTokenEntity) {
        var r = RefreshTokenDoc.builder()
                .id(idGenerator.parse(refreshTokenEntity.getId()))
                .salt(refreshTokenEntity.getSalt())
                .status(refreshTokenEntity.getStatus())
                .updatedAt(refreshTokenEntity.getUpdatedAt())
                .createdAt(refreshTokenEntity.getCreatedAt())
                .ttl(refreshTokenEntity.getTtl())
                .deleted(refreshTokenEntity.isDeleted())
                .createFromToken(Optional.ofNullable(refreshTokenEntity.getCreateFromToken())
                        .map(this::map)
                        .orElse(null))
                .createFromType(refreshTokenEntity.getCreateFromType())
                .credential(Optional.ofNullable(refreshTokenEntity.getCredential())
                        .map(credentialDocMapper::map)
                        .orElse(null))
                .expireAt(refreshTokenEntity.getExpireAt())
                .authSessionId(refreshTokenEntity.getAuthSessionId())
                .build();
        return r;
    }

    @Override
    public RefreshTokenEntity inverseMap(RefreshTokenDoc refreshTokenDoc) {
        RefreshTokenEntity entity = new RefreshTokenEntity();
        entity.setId(refreshTokenDoc.getId().toString());
        entity.setSalt(refreshTokenDoc.getSalt());
        entity.setStatus(refreshTokenDoc.getStatus());
        entity.setUpdatedAt(refreshTokenDoc.getUpdatedAt());
        entity.setCreatedAt(refreshTokenDoc.getCreatedAt());
        entity.setTtl(refreshTokenDoc.getTtl());
        entity.setCreateFromToken(Optional.ofNullable(refreshTokenDoc.getCreateFromToken())
                .map(this::inverseMap)
                .orElse(null));
        entity.setCreateFromType(refreshTokenDoc.getCreateFromType());
        entity.setCredential(Optional.ofNullable(refreshTokenDoc.getCredential())
                .map(credentialDocMapper::inverseMap)
                .orElse(null));
        entity.setExpireAt(refreshTokenDoc.getExpireAt());
        entity.setDeleted(refreshTokenDoc.isDeleted());
        entity.setAuthSessionId(refreshTokenDoc.getAuthSessionId());
        return entity;
    }
}
