package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.token.entity.AccessTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.AccessTokenIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.mapper.CredentialDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.AccessTokenDoc;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class AccessTokenDocMapper implements ExampleDataMapper<AccessTokenEntity, AccessTokenDoc> {

    private final AccessTokenIdGenerator<ObjectId> idGenerator;
    private final CredentialDocMapper credentialDocMapper;
    private final RefreshTokenDocMapper refreshTokenDocMapper;

    @Override
    public AccessTokenDoc map(AccessTokenEntity accessTokenEntity) {
        return AccessTokenDoc.builder()
                .createByRefreshToken(Optional.ofNullable(accessTokenEntity.getCreateByRefreshToken())
                        .map(refreshTokenDocMapper::map)
                        .orElse(null))
                .createdAt(accessTokenEntity.getCreatedAt())
                .credential(Optional.ofNullable(accessTokenEntity.getCredential())
                        .map(credentialDocMapper::map)
                        .orElse(null))
                .ttl(accessTokenEntity.getTtl())
                .expireAt(accessTokenEntity.getExpireAt())
                .id(idGenerator.parse(accessTokenEntity.getId()))
                .sign(accessTokenEntity.getSign())
                .status(accessTokenEntity.getStatus())
                .deleted(accessTokenEntity.isDeleted())
                .updatedAt(accessTokenEntity.getUpdatedAt())
                .authSessionId(accessTokenEntity.getAuthSessionId())
                .build();
    }

    @Override
    public AccessTokenEntity inverseMap(AccessTokenDoc accessTokenDoc) {
        AccessTokenEntity entity = new AccessTokenEntity();
        entity.setId(accessTokenDoc.getId().toString());
        entity.setSign(accessTokenDoc.getSign());
        entity.setStatus(accessTokenDoc.getStatus());
        entity.setTtl(accessTokenDoc.getTtl());
        entity.setCreateByRefreshToken(Optional.ofNullable(accessTokenDoc.getCreateByRefreshToken())
                .map(refreshTokenDocMapper::inverseMap)
                .orElse(null));
        entity.setCredential(Optional.ofNullable(accessTokenDoc.getCredential())
                .map(credentialDocMapper::inverseMap)
                .orElse(null));
        entity.setExpireAt(accessTokenDoc.getExpireAt());
        entity.setCreatedAt(accessTokenDoc.getCreatedAt());
        entity.setUpdatedAt(accessTokenDoc.getUpdatedAt());
        entity.setDeleted(accessTokenDoc.isDeleted());
        entity.setAuthSessionId(accessTokenDoc.getAuthSessionId());
        return entity;
    }
}

