package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class FindByCodeQuery implements ExampleQuery {

    private final String code;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("code").is(code),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
