package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.domain.role.port.RoleIdGenerator;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.RoleAccessRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;

import java.util.Optional;
import java.util.stream.Collectors;

@RequiredArgsConstructor
@Component
public class RoleDocMapper implements ExampleDataMapper<RoleEntity, RoleDoc> {

    private final RoleIdGenerator<ObjectId> idGenerator;
    private final RoleAccessRepository roleAccessRepository;

    @Override
    public RoleDoc map(RoleEntity roleEntity) {
        return RoleDoc.builder()
                .id(idGenerator.parse(roleEntity.getId()))
                .code(roleEntity.getCode())
                .updatedAt(roleEntity.getUpdatedAt())
                .createdAt(roleEntity.getCreatedAt())
                .name(roleEntity.getName())
                .isRegistrationAllowed(roleEntity.isRegistrationAllowed())
                .accessIds(Optional.ofNullable(roleEntity.getAccesses())
                        .map(a -> a.stream().map(RoleAccessEntity::getId).collect(Collectors.toList()))
                        .orElse(null))
                .deleted(roleEntity.isDeleted())
                .build();
    }

    @Override
    public RoleEntity inverseMap(RoleDoc roleDoc) {
        RoleEntity entity = new RoleEntity();
        entity.setId(roleDoc.getId().toString());
        entity.setCode(roleDoc.getCode());
        entity.setName(roleDoc.getName());
        entity.setUpdatedAt(roleDoc.getUpdatedAt());
        entity.setCreatedAt(roleDoc.getCreatedAt());
        entity.setDeleted(roleDoc.isDeleted());
        entity.setRegistrationAllowed(roleDoc.isRegistrationAllowed());
        entity.setAccesses(Optional.ofNullable(roleDoc.getAccessIds())
                .map(l -> l.stream()
                        .map(roleAccessRepository::findById)
                        .filter(Optional::isPresent)
                        .map(Optional::get)
                        .collect(Collectors.toList()))
                .orElse(null));
        return entity;
    }
}
