package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.model;

import com.rcore.database.mongo.commons.document.BaseDocument;
import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.mapping.Document;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.preference.entity.*;

@Document
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Data
@EqualsAndHashCode(callSuper = true)
public class ServicePreferenceDoc extends BaseDocument {
    private String defaultRoleCode;
    private String defaultIsoTwoLetterCountryCode;
    private String defaultPersonalConfirmationCode;
    private String generalConfirmationCode;
    private ConfirmationCodeEntity.Type defaultConfirmationCodeType;
    private ConfirmationCodeDayAttemptLimit confirmationCodeDayAttemptLimits;
    private AuthSessionTypeAttemptLimits deviceIdDayAttemptLimits;
    private AuthSessionTypeAttemptLimits ipV4HourAttemptLimits;
    private AuthSessionWithConfirmationTTLs authSessionWithConfirmationTTLs;
    private ConfirmationCodeMessageBodies confirmationCodeMessageBodies;
    private AttemptLimitsByLoginType authSessionLoginConfirmAttemptsLimits;
    private ConfirmationCodeMessageWebhookProviders defaultConfirmationCodeMessageWebhookProviders;
    private DefaultConfirmationCodeMessageBodies defaultConfirmationCodeMessageBodies;
    private AttemptLimitsByLoginType passwordValidationHourAttemptLimits;
}
