package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import ru.foodtechlab.lib.auth.service.domain.preference.entity.ServicePreferenceEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.ObjectIdMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.model.ServicePreferenceDoc;

public class ServicePreferenceDocMapper implements ExampleDataMapper<ServicePreferenceEntity, ServicePreferenceDoc> {
    @Override
    public ServicePreferenceEntity inverseMap(ServicePreferenceDoc item) {
        ServicePreferenceEntity obj = new ServicePreferenceEntity();


        obj.setId(item.getId().toString());
        obj.setCreatedAt(item.getCreatedAt());
        obj.setUpdatedAt(item.getUpdatedAt());
        obj.setDefaultRoleCode(item.getDefaultRoleCode());
        obj.setDefaultIsoTwoLetterCountryCode(item.getDefaultIsoTwoLetterCountryCode());
        obj.setDefaultPersonalConfirmationCode(item.getDefaultPersonalConfirmationCode());
        obj.setGeneralConfirmationCode(item.getGeneralConfirmationCode());
        obj.setDefaultConfirmationCodeType(item.getDefaultConfirmationCodeType());
        obj.setConfirmationCodeDayAttemptLimits(item.getConfirmationCodeDayAttemptLimits());
        obj.setDeviceIdDayAttemptLimits(item.getDeviceIdDayAttemptLimits());
        obj.setIpV4HourAttemptLimits(item.getIpV4HourAttemptLimits());
        obj.setAuthSessionWithConfirmationTTLs(item.getAuthSessionWithConfirmationTTLs());
        obj.setConfirmationCodeMessageBodies(item.getConfirmationCodeMessageBodies());
        obj.setAuthSessionLoginConfirmAttemptsLimits(item.getAuthSessionLoginConfirmAttemptsLimits());
        obj.setDefaultConfirmationCodeMessageWebhookProviders(item.getDefaultConfirmationCodeMessageWebhookProviders());
        obj.setDefaultConfirmationCodeMessageBodies(item.getDefaultConfirmationCodeMessageBodies());
        obj.setPasswordValidationHourAttemptLimits(item.getPasswordValidationHourAttemptLimits());
        return obj;
    }

    @Override
    public ServicePreferenceDoc map(ServicePreferenceEntity item) {
        ServicePreferenceDoc obj = new ServicePreferenceDoc();

        ObjectIdMapper objectIdMapper = new ObjectIdMapper();
        obj.setId(objectIdMapper.inverseMap(item.getId()));
        obj.setCreatedAt(item.getCreatedAt());
        obj.setUpdatedAt(item.getUpdatedAt());
        obj.setDefaultRoleCode(item.getDefaultRoleCode());
        obj.setDefaultIsoTwoLetterCountryCode(item.getDefaultIsoTwoLetterCountryCode());
        obj.setDefaultPersonalConfirmationCode(item.getDefaultPersonalConfirmationCode());
        obj.setGeneralConfirmationCode(item.getGeneralConfirmationCode());
        obj.setDefaultConfirmationCodeType(item.getDefaultConfirmationCodeType());
        obj.setConfirmationCodeDayAttemptLimits(item.getConfirmationCodeDayAttemptLimits());
        obj.setDeviceIdDayAttemptLimits(item.getDeviceIdDayAttemptLimits());
        obj.setIpV4HourAttemptLimits(item.getIpV4HourAttemptLimits());
        obj.setAuthSessionWithConfirmationTTLs(item.getAuthSessionWithConfirmationTTLs());
        obj.setConfirmationCodeMessageBodies(item.getConfirmationCodeMessageBodies());
        obj.setAuthSessionLoginConfirmAttemptsLimits(item.getAuthSessionLoginConfirmAttemptsLimits());
        obj.setDefaultConfirmationCodeMessageWebhookProviders(item.getDefaultConfirmationCodeMessageWebhookProviders());
        obj.setDefaultConfirmationCodeMessageBodies(item.getDefaultConfirmationCodeMessageBodies());
        obj.setPasswordValidationHourAttemptLimits(item.getPasswordValidationHourAttemptLimits());
        return obj;
    }
}
