package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.migration.entity.MigrationEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.port.MigrationIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.documents.MigrationDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.port.MongoMigrationIdGenerator;

@Component
@RequiredArgsConstructor
public class MigrationMapper implements ExampleDataMapper<MigrationEntity, MigrationDoc> {
    private final MigrationIdGenerator<String> idGenerator;

    @Override
    public MigrationDoc map(MigrationEntity entity) {
        return MigrationDoc
                .builder()
                .id(idGenerator.parse(entity.getId()))
                .version(entity.getVersion())
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .build();
    }

    @Override
    public MigrationEntity inverseMap(MigrationDoc doc) {
        return MigrationEntity
                .builder()
                .id(doc.getId().toString())
                .version(doc.getVersion())
                .createdAt(doc.getCreatedAt())
                .updatedAt(doc.getUpdatedAt())
                .build();
    }
}
