package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;

@RequiredArgsConstructor(staticName = "of")
public class FindByLoginDetailsQuery implements ExampleQuery {

    private final LoginDetails loginDetails;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                loginDetails.getUsername() != null ? Criteria.where("username").is(loginDetails.getUsername()) : new Criteria(),
                loginDetails.getPhoneNumber() != null ? Criteria.where("phoneNumber.value").is(loginDetails.getPhoneNumber().toString()) : new Criteria(),
                loginDetails.getEmail() != null ? Criteria.where("email.value").is(loginDetails.getEmail().toLowerCase()) : new Criteria(),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
