package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.CredentialEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.port.CredentialIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.mapper.RoleDocMapper;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;

@RequiredArgsConstructor
@Component
public class CredentialDocMapper implements ExampleDataMapper<CredentialEntity, CredentialDoc> {

    private final CredentialIdGenerator<ObjectId> credentialIdGenerator;
    private final RoleDocMapper roleDocMapper;

    @Override
    public CredentialDoc map(CredentialEntity credentialEntity) {
        return CredentialDoc.builder()
                .id(credentialIdGenerator.parse(credentialEntity.getId()))
                .password(credentialEntity.getPassword())
                .email(credentialEntity.getEmail())
                .phoneNumber(credentialEntity.getPhoneNumber())
                .username(credentialEntity.getUsername())
                .isBlocked(credentialEntity.isBlocked())
                .deleted(credentialEntity.isDeleted())
                .personalConfirmationCode(credentialEntity.getPersonalConfirmationCode())
                .confirmationCodeDestinationType(credentialEntity.getConfirmationCodeDestinationType())
                .confirmationCodeType(credentialEntity.getConfirmationCodeType())
                .createdAt(credentialEntity.getCreatedAt())
                .updatedAt(credentialEntity.getUpdatedAt())
                .roles(Optional.ofNullable(credentialEntity.getRoles())
                        .map(roles -> roles
                                .stream()
                                .map(r -> new CredentialDoc.Role(roleDocMapper.map(r.getRole()), r.isBlocked()))
                                .collect(Collectors.toList()))
                        .orElse(new ArrayList<>()))
                .build();
    }

    @Override
    public CredentialEntity inverseMap(CredentialDoc credentialDoc) {
        CredentialEntity entity = new CredentialEntity();
        entity.setId(credentialDoc.getId().toString());
        entity.setEmail(credentialDoc.getEmail());
        entity.setPassword(credentialDoc.getPassword());
        entity.setPhoneNumber(credentialDoc.getPhoneNumber());
        entity.setUsername(credentialDoc.getUsername());
        entity.setCreatedAt(credentialDoc.getCreatedAt());
        entity.setUpdatedAt(credentialDoc.getUpdatedAt());
        entity.setBlocked(credentialDoc.getIsBlocked());
        entity.setDeleted(credentialDoc.isDeleted());
        entity.setPersonalConfirmationCode(credentialDoc.getPersonalConfirmationCode());
        entity.setConfirmationCodeDestinationType(credentialDoc.getConfirmationCodeDestinationType());
        entity.setConfirmationCodeType(credentialDoc.getConfirmationCodeType());
        entity.setRoles(Optional.ofNullable(credentialDoc.getRoles())
                .map(roles -> roles
                        .stream()
                        .map(r -> new CredentialEntity.Role(roleDocMapper.inverseMap(r.getRole()), r.isBlocked()))
                        .collect(Collectors.toList()))
                .orElse(new ArrayList<>()));
        return entity;
    }
}
