package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.entity.ConfirmationCodeSendingTaskEntity;

import java.time.LocalDateTime;

public class FindPendingQuery implements ExampleQuery {

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("status").is(ConfirmationCodeSendingTaskEntity.Status.PENDING),
                Criteria.where("nextSendAttemptAt").lte(LocalDateTime.now()),
                DeletedCriteria.getNotDeletedCriteria()
        );
    }
}
