package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.mapper.AuthorizationSessionDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.model.ConfirmationCodeDoc;

import java.util.Optional;

@Component
@RequiredArgsConstructor
public class ConfirmationCodeDocMapper implements ExampleDataMapper<ConfirmationCodeEntity, ConfirmationCodeDoc> {

    private final ConfirmationCodeIdGenerator<ObjectId> confirmationCodeIdGenerator;
    private final AuthorizationSessionDocMapper authorizationSessionDocMapper;

    @Override
    public ConfirmationCodeEntity inverseMap(ConfirmationCodeDoc confirmationCodeDoc) {
        return ConfirmationCodeEntity.builder()
                .id(confirmationCodeDoc.getId().toString())
                .createdAt(confirmationCodeDoc.getCreatedAt())
                .updatedAt(confirmationCodeDoc.getUpdatedAt())
                .deleted(confirmationCodeDoc.isDeleted())
                .code(confirmationCodeDoc.getCode())
                .message(confirmationCodeDoc.getMessage())
                .header(confirmationCodeDoc.getHeader())
                .type(confirmationCodeDoc.getType())
                .webhookProviderUrl(confirmationCodeDoc.getWebhookProviderUrl())
                .confirmationAt(confirmationCodeDoc.getConfirmationAt())
                .confirmationStatus(confirmationCodeDoc.getConfirmationStatus())
                .confirmationCodeDestinationType(confirmationCodeDoc.getConfirmationCodeDestinationType())
                .authSession(Optional.ofNullable(confirmationCodeDoc.getAuthSession())
                        .map(authorizationSessionDocMapper::inverseMap)
                        .orElse(null))
                .build();
    }

    @Override
    public ConfirmationCodeDoc map(ConfirmationCodeEntity entity) {
        return ConfirmationCodeDoc.builder()
                .id(confirmationCodeIdGenerator.parse(entity.getId()))
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .deleted(entity.isDeleted())
                .header(entity.getHeader())
                .webhookProviderUrl(entity.getWebhookProviderUrl())
                .code(entity.getCode())
                .message(entity.getMessage())
                .confirmationCodeDestinationType(entity.getConfirmationCodeDestinationType())
                .confirmationAt(entity.getConfirmationAt())
                .confirmationStatus(entity.getConfirmationStatus())
                .expiredAt(Optional.ofNullable(entity.getAuthSession())
                        .map(AuthSessionEntity::getExpiredAt)
                        .orElse(null))
                .email(entity.getAuthSession().getLoginDetails().getEmail())
                .authSession(Optional.ofNullable(entity.getAuthSession())
                        .map(authorizationSessionDocMapper::map)
                        .orElse(null))
                .phoneNumber(Optional.ofNullable(entity.getAuthSession().getLoginDetails().getPhoneNumber())
                        .map(Object::toString)
                        .orElse(null))
                .type(entity.getType())
                .deviceId(Optional.ofNullable(entity.getAuthSession().getClientInfo()).map(ClientInfo::getDeviceId).orElse(null))
                .loginType(entity.getAuthSession().getLoginType())
                .build();
    }
}
