package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.port.filter.AuthorizationSessionFilters;

import java.util.ArrayList;
import java.util.List;

public class FindWithFiltersQuery extends AbstractExampleQuery {

    private final AuthorizationSessionFilters filters;

    public FindWithFiltersQuery(AuthorizationSessionFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        List<Criteria> criteriaList = new ArrayList<>();
        if (filters.getCredentialId() != null)
            criteriaList.add(Criteria.where("credential.$id").is(new ObjectId(filters.getCredentialId())));
        if (filters.getConfirmationCodeType() != null)
            criteriaList.add(Criteria.where("confirmationCodeType").is(filters.getConfirmationCodeType()));
        IsDeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaList::add);
        if (filters.getLoginType() != null)
            criteriaList.add(Criteria.where("loginType").is(filters.getLoginType()));
        if (filters.getStatus() != null)
            criteriaList.add(Criteria.where("status").is(filters.getStatus()));
        if (filters.getType() != null)
            criteriaList.add(Criteria.where("type").is(filters.getType()));
        if (filters.getIsRegistrationAllowed() != null)
            criteriaList.add(Criteria.where("isRegistrationAllowed").is(filters.getIsRegistrationAllowed()));
        if (filters.getDateFrom() != null)
            criteriaList.add(Criteria.where("createdAt").gte(filters.getDateFrom()));
        if (filters.getDateTo() != null)
            criteriaList.add(Criteria.where("createdAt").lte(filters.getDateTo()));

        if (StringUtils.hasText(filters.getQuery()))
            criteriaList.add(MongoQueryUtils.generateQueryRegEXCriteria(
                    filters.getQuery(),
                    "email",
                    "username",
                    "phoneNumber"
            ));

        return !criteriaList.isEmpty() ? new Criteria().andOperator(criteriaList.toArray(Criteria[]::new)) : new Criteria();
    }

}
