/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.RoleAccessRepository;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.filters.RoleAccessFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.mapper.RoleAccessDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.model.RoleAccessDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindAccessesByRoleIdsQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindGodModeAccessQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindRoleAccessWithFiltersQuery;

@Repository
public class MongoRoleAccessRepository
extends AbstractMongoSafeDeleteRepository<String, RoleAccessEntity, RoleAccessDoc, RoleAccessFilters>
implements RoleAccessRepository {
    public MongoRoleAccessRepository(RoleAccessDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RoleAccessDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public List<RoleAccessEntity> findAccessesByRoles(List<String> roleIds) {
        return this.mongoTemplate.find(FindAccessesByRoleIdsQuery.of(roleIds).getQuery(), RoleAccessDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList());
    }

    protected AbstractExampleQuery getSearchQuery(RoleAccessFilters filters) {
        return new FindRoleAccessWithFiltersQuery(filters);
    }

    public Optional<RoleAccessEntity> findGodModeAccess() {
        return Optional.ofNullable((RoleAccessDoc)((Object)this.mongoTemplate.findOne(new FindGodModeAccessQuery().getQuery(), RoleAccessDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }
}

