/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.migration;

import com.rcore.domain.commons.entity.BaseEntity;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeDestinationType;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.entity.MigrationEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.port.MigrationRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.port.MongoCredentialRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.base.IMigrateToVersion;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.from.CredentialDocFromV3_1_7;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.from.RoleDocFromV3_1_7;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.port.MongoRoleRepository;

public class MigrateToV3_1_7
implements IMigrateToVersion {
    private final MongoTemplate mongoTemplate;
    private final MigrationRepository migrationRepository;

    @Override
    public Integer getVersion() {
        return 1;
    }

    @Override
    public Boolean checkAvailable(MigrationEntity migrationEntity) {
        if (migrationEntity.getVersion() == 0) {
            return true;
        }
        return false;
    }

    @Override
    public MigrationEntity checkAndRunMigration(MigrationEntity migrationEntity) {
        this.migrateRoles();
        this.migrateCreds();
        migrationEntity.setVersion(this.getVersion());
        return (MigrationEntity)this.migrationRepository.save((BaseEntity)migrationEntity);
    }

    private void migrateRoles() {
        Query query = new Query();
        query.limit(1000);
        Long skip = 0L;
        while (true) {
            query.skip(skip.longValue());
            List from = this.mongoTemplate.find(query, RoleDocFromV3_1_7.class, MongoRoleRepository.getCollectionName());
            if (from == null || from.size() == 0) break;
            for (RoleDocFromV3_1_7 needMigrate : from) {
                this.migrateRole(needMigrate);
            }
            skip = skip + (long)from.size();
        }
    }

    private void migrateRole(RoleDocFromV3_1_7 roleDocFromV3_1_7) {
        if (roleDocFromV3_1_7.getAvailableAuthTypes() == null) {
            return;
        }
        Update update = new Update();
        String code = roleDocFromV3_1_7.getName();
        if (code == null && roleDocFromV3_1_7.getCode() != null) {
            code = roleDocFromV3_1_7.getCode();
        }
        update.set("code", (Object)code);
        update.set("name", (Object)code);
        update.set("isDeleted", (Object)false);
        update.set("isRegistrationAllowed", (Object)false);
        update.set("availableAuthTypes", null);
        update.set("availableUseCases", null);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)roleDocFromV3_1_7.getId()));
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, RoleDoc.class);
    }

    private void migrateCreds() {
        Query query = new Query();
        query.limit(1000);
        Long skip = 0L;
        while (true) {
            query.skip(skip.longValue());
            List from = this.mongoTemplate.find(query, CredentialDocFromV3_1_7.class, MongoCredentialRepository.getCollectionName());
            if (from == null || from.size() == 0) break;
            for (CredentialDocFromV3_1_7 needMigrate : from) {
                this.migrateCred(needMigrate);
            }
            skip = skip + (long)from.size();
        }
    }

    private void migrateCred(CredentialDocFromV3_1_7 credentialDocFromV3_1_7) {
        if (credentialDocFromV3_1_7.getStatus() == null) {
            return;
        }
        Update update = new Update();
        ConfirmationCodeDestinationType ccdt = ConfirmationCodeDestinationType.EMAIL;
        if (credentialDocFromV3_1_7.getPhone() == null || credentialDocFromV3_1_7.getPhone().isEmpty()) {
            update.set("phoneNumber", null);
        } else {
            HashMap<String, Object> phoneNumber = new HashMap<String, Object>();
            phoneNumber.put("value", credentialDocFromV3_1_7.getPhone());
            phoneNumber.put("isoTwoLetterCountryCode", "ru");
            phoneNumber.put("isConfirmed", true);
            update.set("phoneNumber", phoneNumber);
            ccdt = ConfirmationCodeDestinationType.PHONE_NUMBER;
        }
        if (credentialDocFromV3_1_7.getEmail() == null || credentialDocFromV3_1_7.getEmail().isEmpty()) {
            update.set("email", null);
        } else {
            HashMap<String, Object> email = new HashMap<String, Object>();
            email.put("value", credentialDocFromV3_1_7.getEmail());
            email.put("isConfirmed", true);
            update.set("email", email);
        }
        update.set("isBlocked", (Object)false);
        update.set("isDeleted", (Object)false);
        update.set("personalConfirmationCode", (Object)1234);
        update.set("confirmationCodeType", (Object)ConfirmationCodeEntity.Type.ONE_TIME);
        update.set("confirmationCodeDestinationType", (Object)ccdt);
        update.set("status", null);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)credentialDocFromV3_1_7.getId()));
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, CredentialDoc.class);
    }

    public MigrateToV3_1_7(MongoTemplate mongoTemplate, MigrationRepository migrationRepository) {
        this.mongoTemplate = mongoTemplate;
        this.migrationRepository = migrationRepository;
    }
}

