/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.CollectionNameUtils;
import com.rcore.domain.commons.port.dto.SearchResult;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.CredentialEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.filters.SearchByRoleFilters;
import ru.foodtechlab.lib.auth.service.domain.credential.port.CredentialRepository;
import ru.foodtechlab.lib.auth.service.domain.credential.port.filters.CredentialFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.mapper.CredentialDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindByEmailQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindByLoginDetailsQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindByPhoneQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindByUsernameQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindCredentialWithFiltersQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindWithFiltersRoleQuery;

@Repository
public class MongoCredentialRepository
extends AbstractMongoSafeDeleteRepository<String, CredentialEntity, CredentialDoc, CredentialFilters>
implements CredentialRepository {
    public MongoCredentialRepository(CredentialDocMapper mapper, MongoTemplate mongoTemplate) {
        super(CredentialDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public Optional<CredentialEntity> findByUsername(String username) {
        return Optional.ofNullable((CredentialDoc)((Object)this.mongoTemplate.findOne(FindByUsernameQuery.of(username).getQuery(), CredentialDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    public Optional<CredentialEntity> findByEmail(String email) {
        return Optional.ofNullable((CredentialDoc)((Object)this.mongoTemplate.findOne(FindByEmailQuery.of(email).getQuery(), CredentialDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    public SearchResult<CredentialEntity> findByRole(SearchByRoleFilters filters) {
        Query query = new FindWithFiltersRoleQuery(filters).getQuery();
        return SearchResult.withItemsAndCount(this.mongoTemplate.find(query, CredentialDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList()), (Long)this.mongoTemplate.count(query.limit(0).skip(0L), CredentialDoc.class));
    }

    public Optional<CredentialEntity> findByPhone(String phone) {
        return Optional.ofNullable((CredentialDoc)((Object)this.mongoTemplate.findOne(FindByPhoneQuery.of(phone).getQuery(), CredentialDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    public Optional<CredentialEntity> findByLoginDetails(LoginDetails loginDetails) {
        return Optional.ofNullable((CredentialDoc)((Object)this.mongoTemplate.findOne(FindByLoginDetailsQuery.of(loginDetails).getQuery(), CredentialDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    protected AbstractExampleQuery getSearchQuery(CredentialFilters filters) {
        return new FindCredentialWithFiltersQuery(filters);
    }

    public static String getCollectionName() {
        return CollectionNameUtils.getCollectionName(CredentialDoc.class);
    }
}

