/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model;

import java.util.List;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.abe.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeDestinationType;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.Email;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.PhoneNumber;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;

@CompoundIndexes(value={@CompoundIndex(name="username", def="{'username': 1}"), @CompoundIndex(name="email", def="{'email': 1}"), @CompoundIndex(name="phoneNumberValue", def="{'phoneNumber.value': 1}"), @CompoundIndex(name="username_email_phoneNumberValue", def="{'username': 1, 'email': 1, 'phoneNumber.value': 1}")})
@Document
public class CredentialDoc
extends BaseDeleteDocument {
    @Indexed
    private String username;
    private String password;
    private PhoneNumber phoneNumber;
    private Email email;
    @Indexed
    private List<Role> roles;
    @Indexed
    private Boolean isBlocked;
    @Indexed
    private ConfirmationCodeDestinationType confirmationCodeDestinationType;
    private String personalConfirmationCode;
    @Indexed
    private ConfirmationCodeEntity.Type confirmationCodeType;

    @Field(value="isDeleted")
    public boolean isDeleted() {
        return super.isDeleted();
    }

    private static ConfirmationCodeEntity.Type $default$confirmationCodeType() {
        return ConfirmationCodeEntity.Type.ONE_TIME;
    }

    protected CredentialDoc(CredentialDocBuilder<?, ?> b) {
        super(b);
        this.username = b.username;
        this.password = b.password;
        this.phoneNumber = b.phoneNumber;
        this.email = b.email;
        this.roles = b.roles;
        this.isBlocked = b.isBlocked;
        this.confirmationCodeDestinationType = b.confirmationCodeDestinationType;
        this.personalConfirmationCode = b.personalConfirmationCode;
        this.confirmationCodeType = b.confirmationCodeType$set ? b.confirmationCodeType$value : CredentialDoc.$default$confirmationCodeType();
    }

    public static CredentialDocBuilder<?, ?> builder() {
        return new CredentialDocBuilderImpl();
    }

    public CredentialDoc() {
        this.confirmationCodeType = CredentialDoc.$default$confirmationCodeType();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public Email getEmail() {
        return this.email;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Boolean getIsBlocked() {
        return this.isBlocked;
    }

    public ConfirmationCodeDestinationType getConfirmationCodeDestinationType() {
        return this.confirmationCodeDestinationType;
    }

    public String getPersonalConfirmationCode() {
        return this.personalConfirmationCode;
    }

    public ConfirmationCodeEntity.Type getConfirmationCodeType() {
        return this.confirmationCodeType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setEmail(Email email) {
        this.email = email;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void setIsBlocked(Boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public void setConfirmationCodeDestinationType(ConfirmationCodeDestinationType confirmationCodeDestinationType) {
        this.confirmationCodeDestinationType = confirmationCodeDestinationType;
    }

    public void setPersonalConfirmationCode(String personalConfirmationCode) {
        this.personalConfirmationCode = personalConfirmationCode;
    }

    public void setConfirmationCodeType(ConfirmationCodeEntity.Type confirmationCodeType) {
        this.confirmationCodeType = confirmationCodeType;
    }

    public static abstract class CredentialDocBuilder<C extends CredentialDoc, B extends CredentialDocBuilder<C, B>>
    extends BaseDeleteDocument.BaseDeleteDocumentBuilder<C, B> {
        private String username;
        private String password;
        private PhoneNumber phoneNumber;
        private Email email;
        private List<Role> roles;
        private Boolean isBlocked;
        private ConfirmationCodeDestinationType confirmationCodeDestinationType;
        private String personalConfirmationCode;
        private boolean confirmationCodeType$set;
        private ConfirmationCodeEntity.Type confirmationCodeType$value;

        protected abstract B self();

        public abstract C build();

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return (B)this.self();
        }

        public B email(Email email) {
            this.email = email;
            return (B)this.self();
        }

        public B roles(List<Role> roles) {
            this.roles = roles;
            return (B)this.self();
        }

        public B isBlocked(Boolean isBlocked) {
            this.isBlocked = isBlocked;
            return (B)this.self();
        }

        public B confirmationCodeDestinationType(ConfirmationCodeDestinationType confirmationCodeDestinationType) {
            this.confirmationCodeDestinationType = confirmationCodeDestinationType;
            return (B)this.self();
        }

        public B personalConfirmationCode(String personalConfirmationCode) {
            this.personalConfirmationCode = personalConfirmationCode;
            return (B)this.self();
        }

        public B confirmationCodeType(ConfirmationCodeEntity.Type confirmationCodeType) {
            this.confirmationCodeType$value = confirmationCodeType;
            this.confirmationCodeType$set = true;
            return (B)this.self();
        }

        public String toString() {
            return "CredentialDoc.CredentialDocBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + this.password + ", phoneNumber=" + this.phoneNumber + ", email=" + this.email + ", roles=" + this.roles + ", isBlocked=" + this.isBlocked + ", confirmationCodeDestinationType=" + this.confirmationCodeDestinationType + ", personalConfirmationCode=" + this.personalConfirmationCode + ", confirmationCodeType$value=" + this.confirmationCodeType$value + ")";
        }
    }

    private static final class CredentialDocBuilderImpl
    extends CredentialDocBuilder<CredentialDoc, CredentialDocBuilderImpl> {
        private CredentialDocBuilderImpl() {
        }

        @Override
        protected CredentialDocBuilderImpl self() {
            return this;
        }

        @Override
        public CredentialDoc build() {
            return new CredentialDoc(this);
        }
    }

    public static class Role {
        @DBRef
        private RoleDoc role;
        private boolean isBlocked;

        public static RoleBuilder builder() {
            return new RoleBuilder();
        }

        public Role(RoleDoc role, boolean isBlocked) {
            this.role = role;
            this.isBlocked = isBlocked;
        }

        public Role() {
        }

        public RoleDoc getRole() {
            return this.role;
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        public void setRole(RoleDoc role) {
            this.role = role;
        }

        public void setBlocked(boolean isBlocked) {
            this.isBlocked = isBlocked;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role other = (Role)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBlocked() != other.isBlocked()) {
                return false;
            }
            RoleDoc this$role = this.getRole();
            RoleDoc other$role = other.getRole();
            return !(this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Role;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBlocked() ? 79 : 97);
            RoleDoc $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            return result;
        }

        public String toString() {
            return "CredentialDoc.Role(role=" + this.getRole() + ", isBlocked=" + this.isBlocked() + ")";
        }

        public static class RoleBuilder {
            private RoleDoc role;
            private boolean isBlocked;

            RoleBuilder() {
            }

            public RoleBuilder role(RoleDoc role) {
                this.role = role;
                return this;
            }

            public RoleBuilder isBlocked(boolean isBlocked) {
                this.isBlocked = isBlocked;
                return this;
            }

            public Role build() {
                return new Role(this.role, this.isBlocked);
            }

            public String toString() {
                return "CredentialDoc.Role.RoleBuilder(role=" + this.role + ", isBlocked=" + this.isBlocked + ")";
            }
        }
    }
}

