package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;

import java.time.Instant;

@RequiredArgsConstructor(staticName = "of")
public class FindAllActiveByUserIdQuery extends AbstractExampleQuery {

    private final String userId;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("userId").is(userId),
                Criteria.where("status").is(RefreshTokenEntity.Status.ACTIVE),
                Criteria.where("expireAt").lte(Instant.now()),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }

    @Override
    public Query getQuery() {
        return Query.of(IsDeletedQuery.notDeleted()).addCriteria(getCriteria());
    }
}
