package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.token.entity.AccessTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.AccessTokenRepository;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.AccessTokenFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.AccessTokenDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.AccessTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.*;

import java.util.List;
import java.util.stream.Collectors;

@Repository
public class MongoAccessTokenRepository extends AbstractMongoSafeDeleteRepository<String, AccessTokenEntity, AccessTokenDoc, AccessTokenFilters> implements AccessTokenRepository {
    public MongoAccessTokenRepository(AccessTokenDocMapper mapper, MongoTemplate mongoTemplate) {
        super(AccessTokenDoc.class, mapper, mongoTemplate);
    }

    @Override
    public void expireAccessToken(String accessTokenId) {
        ExpireAccessTokenQuery expireAccessTokenQuery = ExpireAccessTokenQuery.of(accessTokenId);
        mongoTemplate.updateFirst(expireAccessTokenQuery.getQuery(), expireAccessTokenQuery.getUpdate(), AccessTokenDoc.class);
    }

    @Override
    public void expireAllAccessTokenByRefreshTokenId(String refreshTokenId) {
        var expireAccessTokenByRefreshTokenQuery = ExpireAccessTokenByRefreshTokenQuery.of(refreshTokenId);
        mongoTemplate.updateFirst(expireAccessTokenByRefreshTokenQuery.getQuery(), expireAccessTokenByRefreshTokenQuery.getUpdate(), AccessTokenDoc.class);
    }

    @Override
    public void deactivateAllAccessTokenByRefreshTokenId(String refreshTokenId) {
        var deactivateAllAccessTokenByRefreshTokenIdQuery = DeactivateAllAccessTokenByRefreshTokenIdQuery.of(refreshTokenId);
        mongoTemplate.updateFirst(deactivateAllAccessTokenByRefreshTokenIdQuery.getQuery(), deactivateAllAccessTokenByRefreshTokenIdQuery.getUpdate(), AccessTokenDoc.class);
    }

    @Override
    public void deactivateByCredentialId(String credentialId) {
        DeactivateAllTokensByCredentialQuery query = DeactivateAllTokensByCredentialQuery.of(credentialId);
        mongoTemplate.update(documentClass)
                .matching(query.getQuery())
                .apply(query.getUpdate())
                .all();
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(AccessTokenFilters filters) {
        return new FindAccessTokensQuery(filters);
    }

    @Override
    public List<AccessTokenEntity> findByRefreshTokenId(String refreshTokenId) {
        var query = FindAccessTokensByRefreshTokenQuery.of(refreshTokenId).getQuery();
        return mongoTemplate.find(query, AccessTokenDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }
}
