package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.RoleAccessRepository;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.filters.RoleAccessFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.mapper.RoleAccessDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.model.RoleAccessDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindAccessesByRoleIdsQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindGodModeAccessQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query.FindRoleAccessWithFiltersQuery;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Repository
public class MongoRoleAccessRepository extends AbstractMongoSafeDeleteRepository<String, RoleAccessEntity, RoleAccessDoc, RoleAccessFilters> implements RoleAccessRepository {
    public MongoRoleAccessRepository(RoleAccessDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RoleAccessDoc.class, mapper, mongoTemplate);
    }

    @Override
    public List<RoleAccessEntity> findAccessesByRoles(List<String> roleIds) {
        return mongoTemplate.find(FindAccessesByRoleIdsQuery.of(roleIds).getQuery(), RoleAccessDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(RoleAccessFilters filters) {
        return new FindRoleAccessWithFiltersQuery(filters);
    }

    @Override
    public Optional<RoleAccessEntity> findGodModeAccess() {
        return Optional.ofNullable(mongoTemplate.findOne(new FindGodModeAccessQuery().getQuery(), RoleAccessDoc.class))
                .map(mapper::inverseMap);
    }
}

