package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.abe.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;

@Getter
@Setter
@NoArgsConstructor
@SuperBuilder
public class RoleAccessDoc extends BaseDeleteDocument {
    @Indexed
    private String serviceName;
    @Indexed
    private RoleAccessEntity.Method method;
    @Indexed
    private String requestPathPattern;
    private String createdBy;
    private String editedBy;

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
