package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query;

import com.rcore.database.mongo.commons.query.AbstractModifyQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class DeleteAccessFromRolesQuery extends AbstractModifyQuery {

    private final String accessId;

    @Override
    public Update getUpdate() {
        return new Update().pull("accessIds", accessId);
    }

    @Override
    public FindAndModifyOptions getModifyOptions() {
        return null;
    }

    @Override
    public Criteria getCriteria() {
        return IsDeletedCriteria.getNotDeletedCriteria();
    }
}
