package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.migration;

import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeDestinationType;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.entity.MigrationEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.port.MigrationRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.port.MongoCredentialRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.base.IMigrateToVersion;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.from.CredentialDocFromV3_1_7;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.from.RoleDocFromV3_1_7;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.port.MongoRoleRepository;

import java.util.HashMap;
import java.util.List;

@RequiredArgsConstructor
public class MigrateToV3_1_7 implements IMigrateToVersion {
    private final MongoTemplate mongoTemplate;
    private final MigrationRepository migrationRepository;

    @Override
    public Integer getVersion() {
        return 1;
    }

    @Override
    public Boolean checkAvailable(MigrationEntity migrationEntity) {
        if (migrationEntity.getVersion() == 0) return true;
        return false;
    }

    @Override
    public MigrationEntity checkAndRunMigration(MigrationEntity migrationEntity) {
        migrateRoles();
        migrateCreds();

        migrationEntity.setVersion(getVersion());
        return migrationRepository.save(migrationEntity);
    }

    private void migrateRoles() {
        Query query = new Query();
        query.limit(1000);
        Long skip = 0l;

        while (true) {
            query.skip(skip);
            List<RoleDocFromV3_1_7> from = mongoTemplate.find(
                    query,
                    RoleDocFromV3_1_7.class,
                    MongoRoleRepository.getCollectionName());
            if(from == null || from.size() == 0){
                break;
            }
            for (RoleDocFromV3_1_7 needMigrate : from) {
                migrateRole(needMigrate);
            }
            skip += from.size();
        }
    }

    private void migrateRole(RoleDocFromV3_1_7 roleDocFromV3_1_7){
        if(roleDocFromV3_1_7.getAvailableAuthTypes() == null){
            return;
        }

        Update update = new Update();
        String code = roleDocFromV3_1_7.getName();
        if(code == null && roleDocFromV3_1_7.getCode() != null){
            // Раньше только name заполнялось, если все же есть CODE то используем его
            code = roleDocFromV3_1_7.getCode();
        }

        update.set("code", code);
        update.set("name", code);
        update.set("isDeleted", false);
        update.set("isRegistrationAllowed", false);
        update.set("availableAuthTypes", null);
        update.set("availableUseCases", null);
        Query query = new Query(Criteria.where("id").is(roleDocFromV3_1_7.getId()));
        mongoTemplate.updateFirst(query, update, RoleDoc.class);
    }

    private void migrateCreds() {
        Query query = new Query();
        query.limit(1000);
        Long skip = 0l;

        while (true) {
            query.skip(skip);
            List<CredentialDocFromV3_1_7> from = mongoTemplate.find(
                    query,
                    CredentialDocFromV3_1_7.class,
                    MongoCredentialRepository.getCollectionName());
            if(from == null || from.size() == 0){
                break;
            }
            for (CredentialDocFromV3_1_7 needMigrate : from) {
                migrateCred(needMigrate);
            }
            skip += from.size();
        }
    }

    private void migrateCred(CredentialDocFromV3_1_7 credentialDocFromV3_1_7) {
        if (credentialDocFromV3_1_7.getStatus() == null) {
            // STATUS есть только в сущностях до версии 3-1-7
            return;
        }
        Update update = new Update();
        ConfirmationCodeDestinationType ccdt = ConfirmationCodeDestinationType.EMAIL;

        if (credentialDocFromV3_1_7.getPhone() == null || credentialDocFromV3_1_7.getPhone().isEmpty()) {
            update.set("phoneNumber", null);
        } else {
            HashMap<String, Object> phoneNumber = new HashMap<>();
            phoneNumber.put("value", credentialDocFromV3_1_7.getPhone());
            phoneNumber.put("isoTwoLetterCountryCode", "ru");
            phoneNumber.put("isConfirmed", true);
            update.set("phoneNumber", phoneNumber);
            ccdt = ConfirmationCodeDestinationType.PHONE_NUMBER;
        }

        if (credentialDocFromV3_1_7.getEmail() == null || credentialDocFromV3_1_7.getEmail().isEmpty()) {
            update.set("email", null);
        } else {
            HashMap<String, Object> email = new HashMap<>();
            email.put("value", credentialDocFromV3_1_7.getEmail());
            email.put("isConfirmed", true);// Будем считать что все текущие подтвердили
            update.set("email", email);
        }

        update.set("isBlocked", false);
        update.set("isDeleted", false);
        update.set("personalConfirmationCode", 1234);
        update.set("confirmationCodeType", ConfirmationCodeEntity.Type.ONE_TIME);
        update.set("confirmationCodeDestinationType", ccdt);
        update.set("status", null);//удаляем это поле, что бы потом не проходить по этоой сущности еще раз

        Query query = new Query(Criteria.where("id").is(credentialDocFromV3_1_7.getId()));
        mongoTemplate.updateFirst(query, update, CredentialDoc.class);
    }
}
