package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.credential.filters.SearchByRoleFilters;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;

import java.util.List;
import java.util.stream.Collectors;

public class FindWithFiltersRoleQuery extends AbstractExampleQuery {
    private final List<RoleEntity> roles;

    public FindWithFiltersRoleQuery(SearchByRoleFilters request) {
        super(request);
        roles = request.getRoles();
    }

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria
                        .where("roles.role")
                        .in(roles
                                .stream()
                                .map(entity -> RoleDoc.builder().id(new ObjectId(entity.getId())).build())
                                .collect(Collectors.toList())
                        ),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
