package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.credential.port.filters.CredentialFilters;

import java.util.HashSet;
import java.util.Set;

public class FindCredentialWithFiltersQuery extends AbstractExampleQuery {
    private final CredentialFilters filters;

    public FindCredentialWithFiltersQuery(CredentialFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        Set<Criteria> criteriaSet = new HashSet<>();

        IsDeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaSet::add);

        if (filters.getBlocked() != null)
            criteriaSet.add(Criteria.where("isBlocked").is(filters.getBlocked()));

        if (filters.getRoleIds() != null && !filters.getRoleIds().isEmpty()) {
            Criteria allRoles = new Criteria().andOperator(filters.getRoleIds()
                    .stream()
                    .map(r -> Criteria.where("roles").elemMatch(Criteria.where("role.$id").is(new ObjectId(r))))
                    .toArray(Criteria[]::new));
            criteriaSet.add(new Criteria().andOperator(allRoles));
        }
        if (filters.getConfirmationCodeType() != null)
            criteriaSet.add(Criteria.where("confirmationCodeType").is(filters.getConfirmationCodeType()));

        if (filters.getConfirmationCodeDestinationType() != null)
            criteriaSet.add(Criteria.where("confirmationCodeDestinationType").is(filters.getConfirmationCodeDestinationType()));

        if (StringUtils.hasText(filters.getQuery()))
            criteriaSet.add(MongoQueryUtils.generateQueryRegEXCriteria(filters.getQuery(),
                    "username",
                    "phoneNumber.value",
                    "email.value"
            ));


        if (!criteriaSet.isEmpty())
            return new Criteria().andOperator(criteriaSet.toArray(Criteria[]::new));
        else
            return new Criteria();
    }
}
