package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.abe.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.entity.ConfirmationCodeSendingTaskEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.model.ConfirmationCodeDoc;

import java.time.Instant;
import java.util.List;

@CompoundIndexes({
        @CompoundIndex(name = "status", def = "{'status': -1}"),
        @CompoundIndex(name = "status_nextSendAttemptAt_isDeleted", def = "{'status': 1, 'nextSendAttemptAt': 1, 'isDeleted': 1}")
})
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Data
@EqualsAndHashCode(callSuper = true)
public class ConfirmationCodeSendingTaskDoc extends BaseDeleteDocument {

    @DBRef
    private ConfirmationCodeDoc confirmationCode;
    private ConfirmationCodeSendingTaskEntity.Status status;
    private Instant sendingTime;
    private Long sendAttemptsLimit;
    private Long sendAttempts;
    private List<String> errors;
    private Instant nextSendAttemptAt;

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
