package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.AllArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;

@AllArgsConstructor(staticName = "of")
public class FindCodeBySessionQuery implements ExampleQuery {

    private final String authSessionId;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("authSession.$id").is(new ObjectId(authSessionId)),
                DeletedCriteria.getNotDeletedCriteria()
        );
    }


}
