package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.abe.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeRepository;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.filter.ConfirmationCodeFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.mapper.ConfirmationCodeDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.model.ConfirmationCodeDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindCodeBySessionQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindLastNotConfirmedForCredentialQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindWithFiltersQuery;

import java.util.Optional;

@Repository
public class MongoConfirmationCodeRepository extends AbstractMongoSafeDeleteRepository<String, ConfirmationCodeEntity, ConfirmationCodeDoc, ConfirmationCodeFilters> implements ConfirmationCodeRepository {

    public MongoConfirmationCodeRepository(ConfirmationCodeDocMapper mapper, MongoTemplate mongoTemplate) {
        super(ConfirmationCodeDoc.class, mapper, mongoTemplate);
    }

    @Override
    public Optional<ConfirmationCodeEntity> findLastNotConfirmedForCredential(LoginDetails loginDetails, String deviceToken) {
        return Optional.ofNullable(mongoTemplate.findOne(FindLastNotConfirmedForCredentialQuery.of(loginDetails, deviceToken).getQuery(), ConfirmationCodeDoc.class))
                .map(mapper::inverseMap);
    }


    @Override
    protected AbstractExampleQuery getSearchQuery(ConfirmationCodeFilters filters) {
        return new FindWithFiltersQuery(filters);
    }

    @Override
    public Long count() {
        return mongoTemplate.count(new Query(), ConfirmationCodeDoc.class);
    }

    @Override
    public Optional<ConfirmationCodeEntity> findCodeBySession(String authSessionId) {
        var query = FindCodeBySessionQuery.of(authSessionId).getQuery();
        return Optional.ofNullable(mongoTemplate.findOne(query, ConfirmationCodeDoc.class))
                .map(mapper::inverseMap);
    }
}
