package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.abe.mongo.util.DeletedCriteria;
import ru.foodtechlab.abe.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

@RequiredArgsConstructor(staticName = "of")
public class FindByLoginDetailsInDayQuery implements ExampleQuery {

    private final LoginDetails loginDetails;

    @Override
    public Criteria getCriteria() {
        var time = Instant.now().minus(1, ChronoUnit.DAYS);
        return new Criteria().andOperator(
                loginDetails.getEmail() != null ? Criteria.where("email").is(loginDetails.getEmail().toLowerCase()) : new Criteria(),
                loginDetails.getPhoneNumber() != null ? Criteria.where("phoneNumber").is(loginDetails.getPhoneNumber().getValue()) : new Criteria(),
                loginDetails.getUsername() != null ? Criteria.where("username").is(loginDetails.getUsername()) : new Criteria(),
                Criteria.where("status").ne(AuthSessionEntity.Status.INIT_ERROR),
                Criteria.where("createdAt").gte(time),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
