package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model;

import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.abe.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.AccessTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.RefreshTokenDoc;

import java.time.Instant;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Document
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Data
@CompoundIndexes({
        @CompoundIndex(name = "ipv4_type_createdAt_isDeleted", def = "{ipV4: 1, type: 1, createdAt: 1, isDeleted: 1}"),
        @CompoundIndex(name = "status_username_deviceId_isDeleted", def = "{'status': 1, 'username': 1, 'deviceId': 1, 'isDeleted': 1}"),
        @CompoundIndex(name = "username_type_createdAt_status_isDeleted", def = "{'username': 1, 'type': 1, 'createdAt': 1, 'status': 1, 'isDeleted': 1}"),
        @CompoundIndex(name = "deviceId_type_createdAt_isDeleted", def = "{'deviceId': 1, 'type': 1, 'createdAt': 1, 'isDeleted': 1}")
})
public class AuthSessionDoc extends BaseDeleteDocument {

    private Boolean isRegistrationAllowed;
    private ConfirmationCodeEntity.Type confirmationCodeType;
    private Long ttl;
    private Instant expireAt;
    @DBRef
    private CredentialDoc credential;
    @DBRef
    private RoleDoc role;
    private AuthSessionEntity.Status status;
    private AuthSessionEntity.Type type;
    private AuthSessionEntity.LoginType loginType;
    private List<String> errors;
    private Long authSessionLoginConfirmAttemptsLimit;
    private Long authSessionLoginConfirmAttempts;
    private Long authSessionLoginInitAttempts;
    @Indexed
    private String phoneNumber;
    private String isoTwoLetterCountryCode;
    @Indexed
    private String username;
    @Indexed
    private String email;
    private String deviceId;
    private String ipV4;
    private ApplicationDetails applicationDetails;

    @DBRef
    private AccessTokenDoc accessToken;
    @DBRef
    private RefreshTokenDoc refreshToken;
    @Version
    private Long version;

    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    @Data
    public static class ApplicationDetails {
        private String name;
        private String platform;
        private String versionName;
    }

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
