/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exceptionhandler.core;

import java.time.Instant;
import java.util.List;

public class ErrorApiResponse<Error> {
    private List<Error> errors;
    private int status;
    private String path;
    private Instant timestamp = Instant.now();
    private String traceId;

    public ErrorApiResponse(List<Error> errors, int status) {
        this.errors = errors;
        this.status = status;
    }

    public ErrorApiResponse(List<Error> errors, int status, String path, String traceId) {
        this.errors = errors;
        this.status = status;
        this.path = path;
    }

    public static <Error> ErrorApiResponse<Error> of(List<Error> errors, int status, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, status, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> badRequest(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 400, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> unauthorized(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 401, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> tooManyRequest(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 429, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> forbidden(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 403, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> notFound(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 404, path, traceId);
    }

    public static <Error> ErrorApiResponse<Error> internalServerError(List<Error> errors, String path, String traceId) {
        return new ErrorApiResponse<Error>(errors, 500, path, traceId);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public int getStatus() {
        return this.status;
    }

    public String getPath() {
        return this.path;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorApiResponse)) {
            return false;
        }
        ErrorApiResponse other = (ErrorApiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        List<Error> this$errors = this.getErrors();
        List<Error> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        List<Error> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    public ErrorApiResponse() {
    }

    public String toString() {
        return "ErrorApiResponse(errors=" + this.getErrors() + ", status=" + this.getStatus() + ", path=" + this.getPath() + ", timestamp=" + this.getTimestamp() + ", traceId=" + this.getTraceId() + ")";
    }
}

