/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exceptionhandler.core;

public class Error {
    private PresentationData presentationData;
    private String domain;
    private String reason;
    private String details;

    public Error(String title, String message, String domain, String reason, String details) {
        this.presentationData = PresentationData.of(title, message);
        this.domain = domain.toUpperCase();
        this.reason = reason.toUpperCase();
        this.details = details;
    }

    public static Error of(String title, String message, String domain, String reason, String detail) {
        return new Error(title, message, domain, reason, detail);
    }

    public static Error unknownError(String title, String message, Throwable e) {
        return new Error(title, message, "SERVER", "UNKNOWN", e.getClass().getSimpleName() + ": " + e.getMessage());
    }

    public PresentationData getPresentationData() {
        return this.presentationData;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDetails() {
        return this.details;
    }

    public void setPresentationData(PresentationData presentationData) {
        this.presentationData = presentationData;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Error)) {
            return false;
        }
        Error other = (Error)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PresentationData this$presentationData = this.getPresentationData();
        PresentationData other$presentationData = other.getPresentationData();
        if (this$presentationData == null ? other$presentationData != null : !((Object)this$presentationData).equals(other$presentationData)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Error;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PresentationData $presentationData = this.getPresentationData();
        result = result * 59 + ($presentationData == null ? 43 : ((Object)$presentationData).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    public Error() {
    }

    public String toString() {
        return "Error(presentationData=" + this.getPresentationData() + ", domain=" + this.getDomain() + ", reason=" + this.getReason() + ", details=" + this.getDetails() + ")";
    }

    public static class PresentationData {
        private String title;
        private String message;

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PresentationData)) {
                return false;
            }
            PresentationData other = (PresentationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PresentationData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "Error.PresentationData(title=" + this.getTitle() + ", message=" + this.getMessage() + ")";
        }

        private PresentationData(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public static PresentationData of(String title, String message) {
            return new PresentationData(title, message);
        }

        public PresentationData() {
        }
    }
}

