/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exceptionhandler.api;

import com.rcore.domain.commons.exception.BadRequestDomainException;
import com.rcore.domain.commons.exception.DefaultIncorrectValueException;
import com.rcore.domain.commons.exception.DefaultResourceNotFoundException;
import com.rcore.domain.commons.exception.DefaultValueIsNotUniqueException;
import com.rcore.domain.commons.exception.DefaultValueIsRequiredException;
import com.rcore.domain.commons.exception.DomainException;
import com.rcore.domain.commons.exception.ForbiddenDomainException;
import com.rcore.domain.commons.exception.InternalServerDomainException;
import com.rcore.domain.commons.exception.NotFoundDomainException;
import com.rcore.domain.commons.exception.TooManyRequestsDomainException;
import com.rcore.domain.commons.exception.UnauthorizedDomainException;
import com.rcore.domain.security.exceptions.CredentialPermissionInsufficientException;
import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import io.foodtechlab.exceptionhandler.api.ErrorFactory;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class BasicExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicExceptionHandler.class);
    private final ErrorFactory errorFactory;

    @ExceptionHandler(value={UnauthorizedDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleUnauthorizedDomainException(UnauthorizedDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.unauthorized(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={TooManyRequestsDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleTooManyRequestsDomainException(TooManyRequestsDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.tooManyRequest(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={NotFoundDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleUnauthorizedDomainException(NotFoundDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.notFound(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={BadRequestDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleBadRequestDomainException(BadRequestDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.badRequest(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={ForbiddenDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleForbiddenDomainException(ForbiddenDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.forbidden(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={HttpCommunicationException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleUnknownException(HttpCommunicationException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse response = (ErrorApiResponse)e.getResponse();
        e.printStackTrace();
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleAccessDeniedException(AccessDeniedException e, HttpServletRequest request, Locale locale) {
        CredentialPermissionInsufficientException error = new CredentialPermissionInsufficientException();
        ErrorApiResponse errorApiResponse = ErrorApiResponse.forbidden(error.getErrors().stream().map(er -> this.errorFactory.buildByError((DomainException.Error)er, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={InternalServerDomainException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleInternalServerException(InternalServerDomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.internalServerError(e.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleUnknownException(Exception e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = ErrorApiResponse.internalServerError(Collections.singletonList(this.errorFactory.buildUnknownException(e, locale)), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleUndeclaredException(UndeclaredThrowableException e, HttpServletRequest request, Locale locale) {
        Throwable ex = e.getUndeclaredThrowable();
        if (ex == null) {
            ex = e;
        }
        ErrorApiResponse errorApiResponse = ErrorApiResponse.internalServerError(Collections.singletonList(this.errorFactory.buildUnknownException(ex, locale)), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    @ExceptionHandler(value={DefaultIncorrectValueException.class, DefaultResourceNotFoundException.class, DefaultValueIsNotUniqueException.class, DefaultValueIsRequiredException.class})
    public ResponseEntity<ErrorApiResponse<Error>> handleDefaultException(DomainException e, HttpServletRequest request, Locale locale) {
        ErrorApiResponse errorApiResponse = e instanceof DefaultResourceNotFoundException ? ErrorApiResponse.notFound(Collections.singletonList(this.errorFactory.buildByDefaultException(e, locale)), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId()) : ErrorApiResponse.badRequest(Collections.singletonList(this.errorFactory.buildByDefaultException(e, locale)), (String)request.getRequestURI(), (String)this.errorFactory.getTraceId());
        e.printStackTrace();
        return ResponseEntity.status((int)errorApiResponse.getStatus()).body((Object)errorApiResponse);
    }

    public BasicExceptionHandler(ErrorFactory errorFactory) {
        this.errorFactory = errorFactory;
    }
}

