/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exceptionhandler.api.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rcore.domain.commons.exception.DomainException;
import com.rcore.domain.commons.exception.ForbiddenDomainException;
import com.rcore.domain.commons.exception.UnauthorizedDomainException;
import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import io.foodtechlab.exceptionhandler.api.ErrorFactory;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationErrorHandler
implements AuthenticationFailureHandler {
    private final ObjectMapper objectMapper;
    private final ErrorFactory errorFactory;

    public void onAuthenticationFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException, ServletException {
        httpServletResponse.setContentType("application/json");
        httpServletRequest.setCharacterEncoding("UTF-8");
        Locale locale = httpServletRequest.getLocale();
        int statusCode = 500;
        if (e.getCause() != null && e.getCause() instanceof HttpCommunicationException) {
            HttpCommunicationException httpCommunicationException = (HttpCommunicationException)e.getCause();
            ErrorApiResponse errorApiResponse = (ErrorApiResponse)this.objectMapper.convertValue(httpCommunicationException.getResponse(), (TypeReference)new TypeReference<ErrorApiResponse<Error>>(){});
            String errorResponse = this.objectMapper.writeValueAsString(httpCommunicationException.getResponse());
            httpServletResponse.getWriter().write(errorResponse);
            httpServletResponse.setStatus(errorApiResponse.getStatus());
            return;
        }
        if (e.getCause() != null) {
            if (e.getCause() instanceof UnauthorizedDomainException) {
                statusCode = 401;
            }
            if (e.getCause() instanceof ForbiddenDomainException) {
                statusCode = 403;
            }
        }
        httpServletResponse.setStatus(statusCode);
        if (statusCode != 500) {
            DomainException domainException = (DomainException)e.getCause();
            httpServletResponse.getWriter().write(this.objectMapper.writeValueAsString((Object)ErrorApiResponse.of(domainException.getErrors().stream().map(error -> this.errorFactory.buildByError((DomainException.Error)error, locale)).collect(Collectors.toList()), (int)statusCode, (String)httpServletRequest.getRequestURI(), (String)this.errorFactory.getTraceId())));
            return;
        }
        ErrorApiResponse responseBody = ErrorApiResponse.internalServerError(Collections.singletonList(this.errorFactory.buildUnknownException((Throwable)e, locale)), (String)httpServletRequest.getRequestURI(), (String)this.errorFactory.getTraceId());
        httpServletResponse.getWriter().write(this.objectMapper.writeValueAsString((Object)responseBody));
    }

    public AuthenticationErrorHandler(ObjectMapper objectMapper, ErrorFactory errorFactory) {
        this.objectMapper = objectMapper;
        this.errorFactory = errorFactory;
    }
}

