/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exceptionhandler.api;

import com.rcore.domain.commons.exception.DefaultIncorrectValueException;
import com.rcore.domain.commons.exception.DefaultResourceNotFoundException;
import com.rcore.domain.commons.exception.DefaultValueIsNotUniqueException;
import com.rcore.domain.commons.exception.DefaultValueIsRequiredException;
import com.rcore.domain.commons.exception.DomainException;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.i18n.I18NHelper;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.stereotype.Component;

@Component
public class ErrorFactory {
    private final I18NHelper i18NHelper;
    private final Tracer tracer;

    public String getTraceId() {
        Span span = this.tracer.currentSpan();
        if (span != null) {
            return span.context().traceId();
        }
        return "unknown";
    }

    public Error buildByError(DomainException.Error error, Locale locale) {
        String reason = error.getReason();
        if (error.getReason().endsWith("_IS_INCORRECT")) {
            reason = "_IS_INCORRECT";
        } else if (error.getReason().endsWith("_IS_NOT_UNIQUE")) {
            reason = "_IS_NOT_UNIQUE";
        } else if (error.getReason().endsWith("_IS_REQUIRED")) {
            reason = "_IS_REQUIRED";
        }
        String finalReason = reason;
        String title = this.notNullElseGet(this.i18NHelper.getProperty(error.getDomain() + "." + error.getReason() + ".title", locale), () -> this.i18NHelper.getProperty("*." + finalReason + ".title", locale));
        String message = this.notNullElseGet(this.i18NHelper.getProperty(error.getDomain() + "." + error.getReason() + ".message", locale), () -> this.i18NHelper.getProperty("*." + finalReason + ".message", locale));
        if (error.getInvalidFieldName() != null) {
            message = message.replace("{value}", error.getInvalidFieldName());
        }
        return Error.of((String)title, (String)message, (String)error.getDomain(), (String)error.getReason(), (String)error.getDetails());
    }

    private String notNullElseGet(String obj, Supplier<String> supplier) {
        if (obj != null) {
            return obj;
        }
        return supplier.get();
    }

    public Error buildByDefaultException(DomainException exception, Locale locale) {
        DefaultIncorrectValueException e;
        DomainException.Error error = (DomainException.Error)exception.getErrors().get(0);
        String value = "";
        String reason = null;
        if (exception instanceof DefaultIncorrectValueException) {
            e = (DefaultIncorrectValueException)exception;
            value = this.getLocalizedFiledOrValue(error.getDomain(), e.getInvalidFieldName(), locale);
            reason = "_IS_INCORRECT";
        } else if (exception instanceof DefaultValueIsRequiredException) {
            e = (DefaultValueIsRequiredException)exception;
            value = this.getLocalizedFiledOrValue(error.getDomain(), e.getInvalidFieldName(), locale);
            reason = "_IS_REQUIRED";
        } else if (exception instanceof DefaultValueIsNotUniqueException) {
            e = (DefaultValueIsNotUniqueException)exception;
            value = this.getLocalizedFiledOrValue(error.getDomain(), e.getInvalidFieldName(), locale);
            reason = "_IS_NOT_UNIQUE";
        } else if (exception instanceof DefaultResourceNotFoundException) {
            value = this.getLocalizedDomainOrValue(error.getDomain(), locale).toLowerCase();
            reason = "NOT_FOUND";
        }
        String title = this.i18NHelper.getProperty("*." + reason + ".title", locale);
        String message = this.i18NHelper.getProperty("*." + reason + ".message", locale).replace("{value}", value);
        return Error.of((String)title, (String)message, (String)error.getDomain(), (String)error.getReason(), (String)error.getDetails());
    }

    private String getLocalizedFiledOrValue(String domain, String filedName, Locale locale) {
        return Objects.requireNonNullElse(this.i18NHelper.getProperty(domain + "." + filedName, locale), filedName);
    }

    private String getLocalizedDomainOrValue(String domain, Locale locale) {
        return Objects.requireNonNullElse(this.i18NHelper.getProperty(domain, locale), domain);
    }

    public Error buildUnknownException(Throwable ex, Locale locale) {
        return Error.unknownError((String)this.i18NHelper.getProperty("SERVER.UNKNOWN.title", locale), (String)this.i18NHelper.getProperty("SERVER.UNKNOWN.message", locale), (Throwable)ex);
    }

    public ErrorFactory(I18NHelper i18NHelper, Tracer tracer) {
        this.i18NHelper = i18NHelper;
        this.tracer = tracer;
    }
}

