/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.domain.entities;

import java.time.Instant;
import java.util.Objects;

public class ExternalLink {
    private String id;
    private String name;
    private String type;
    private String externalSystemAccountId;
    private Instant lastSyncDate;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalLink el = (ExternalLink)obj;
        if (el.getId().equals(this.getId())) {
            if (this.getType() == null && el.getType() == null) {
                return true;
            }
            if (this.getType() != null && el.getType() != null && this.getType().equals(el.getType())) {
                if (this.getExternalSystemAccountId() == null || el.getExternalSystemAccountId() == null) {
                    return true;
                }
                if (this.getExternalSystemAccountId() != null && el.getExternalSystemAccountId() != null && el.getExternalSystemAccountId().equals(this.getExternalSystemAccountId())) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.externalSystemAccountId != null) {
            return Objects.hash(this.id, this.externalSystemAccountId);
        }
        return Objects.hash(this.id);
    }

    public boolean compareType(Class clazz) {
        if (this.type == null) {
            return false;
        }
        return clazz.getName().equals(this.type);
    }

    public static ExternalLinkBuilder builder() {
        return new ExternalLinkBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getExternalSystemAccountId() {
        return this.externalSystemAccountId;
    }

    public Instant getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setExternalSystemAccountId(String externalSystemAccountId) {
        this.externalSystemAccountId = externalSystemAccountId;
    }

    public void setLastSyncDate(Instant lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public ExternalLink() {
    }

    public ExternalLink(String id, String name, String type, String externalSystemAccountId, Instant lastSyncDate) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.externalSystemAccountId = externalSystemAccountId;
        this.lastSyncDate = lastSyncDate;
    }

    public static class ExternalLinkBuilder {
        private String id;
        private String name;
        private String type;
        private String externalSystemAccountId;
        private Instant lastSyncDate;

        ExternalLinkBuilder() {
        }

        public ExternalLinkBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ExternalLinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ExternalLinkBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ExternalLinkBuilder externalSystemAccountId(String externalSystemAccountId) {
            this.externalSystemAccountId = externalSystemAccountId;
            return this;
        }

        public ExternalLinkBuilder lastSyncDate(Instant lastSyncDate) {
            this.lastSyncDate = lastSyncDate;
            return this;
        }

        public ExternalLink build() {
            return new ExternalLink(this.id, this.name, this.type, this.externalSystemAccountId, this.lastSyncDate);
        }

        public String toString() {
            return "ExternalLink.ExternalLinkBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", externalSystemAccountId=" + this.externalSystemAccountId + ", lastSyncDate=" + this.lastSyncDate + ")";
        }
    }
}

