/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.domain.entities;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.foodtechlab.abe.domain.entities.BaseDeleteEntity;
import ru.foodtechlab.abe.domain.entities.DeleteProperty;
import ru.foodtechlab.abe.domain.entities.ExternalLink;
import ru.foodtechlab.abe.domain.entities.ExternalProperty;

public abstract class BaseExternalDeleteEntity<Id>
extends BaseDeleteEntity<Id>
implements DeleteProperty,
ExternalProperty {
    protected List<ExternalLink> externalLinks = new ArrayList<ExternalLink>();

    public void addExternalLink(ExternalLink newLink) {
        if (this.externalLinks == null) {
            this.externalLinks = new ArrayList<ExternalLink>();
        }
        Boolean hasExternal = false;
        for (ExternalLink el : this.externalLinks) {
            if (!el.equals(newLink)) continue;
            el.setName(newLink.getName() != null ? newLink.getName() : el.getName());
            el.setType(newLink.getType() != null ? newLink.getType() : el.getType());
            el.setExternalSystemAccountId(newLink.getExternalSystemAccountId() != null ? newLink.getExternalSystemAccountId() : el.getExternalSystemAccountId());
            el.setLastSyncDate(Instant.now());
            hasExternal = true;
        }
        if (!hasExternal.booleanValue()) {
            if (newLink.getLastSyncDate() == null) {
                newLink.setLastSyncDate(Instant.now());
            }
            if (this.externalLinks.size() == 0) {
                this.externalLinks = new ArrayList<ExternalLink>();
            }
            this.externalLinks.add(newLink);
        }
        ArrayList<ExternalLink> unicLinks = new ArrayList<ExternalLink>();
        for (ExternalLink externalLink : this.externalLinks) {
            Boolean needAdd = true;
            try {
                for (ExternalLink unic : unicLinks) {
                    if (!unic.getId().equals(externalLink.getId()) || !unic.getExternalSystemAccountId().equals(externalLink.getExternalSystemAccountId()) || !unic.getType().equals(externalLink.getType())) continue;
                    needAdd = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!needAdd.booleanValue()) continue;
            unicLinks.add(externalLink);
        }
        this.externalLinks = unicLinks;
    }

    public void addExternalLink(List<ExternalLink> links) {
        for (ExternalLink externalLink : links) {
            this.addExternalLink(externalLink);
        }
    }

    public Optional<ExternalLink> getExternalLinkByType(String externalType) {
        if (this.externalLinks == null) {
            return Optional.empty();
        }
        for (ExternalLink externalLink : this.externalLinks) {
            if (!externalLink.getType().equals(externalType)) continue;
            return Optional.of(externalLink);
        }
        return Optional.empty();
    }

    protected BaseExternalDeleteEntity(BaseExternalDeleteEntityBuilder<Id, ?, ?> b) {
        super(b);
        this.externalLinks = b.externalLinks;
    }

    @Override
    public List<ExternalLink> getExternalLinks() {
        return this.externalLinks;
    }

    @Override
    public void setExternalLinks(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public BaseExternalDeleteEntity(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public BaseExternalDeleteEntity() {
    }

    public static abstract class BaseExternalDeleteEntityBuilder<Id, C extends BaseExternalDeleteEntity<Id>, B extends BaseExternalDeleteEntityBuilder<Id, C, B>>
    extends BaseDeleteEntity.BaseDeleteEntityBuilder<Id, C, B> {
        private List<ExternalLink> externalLinks;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B externalLinks(List<ExternalLink> externalLinks) {
            this.externalLinks = externalLinks;
            return (B)((Object)this.self());
        }

        @Override
        public String toString() {
            return "BaseExternalDeleteEntity.BaseExternalDeleteEntityBuilder(super=" + super.toString() + ", externalLinks=" + this.externalLinks + ")";
        }
    }
}

