package ru.foodtechlab.abe.domain.usecase;

import com.rcore.event.driven.EventDispatcher;
import ru.foodtechlab.abe.domain.entities.BaseDeleteEntity;
import ru.foodtechlab.abe.domain.events.AbstractEntityRestoreEvent;
import ru.foodtechlab.abe.domain.port.SafeDeleteRepository;
import ru.foodtechlab.abe.domain.port.SafeReadRepository;

public abstract class AbstractRestoreDeleteWithEventUseCase<ID, R extends SafeReadRepository<ID, E, ?> & SafeDeleteRepository<ID>, E extends BaseDeleteEntity<ID>> extends AbstractActionWithWithDeletedEntityUseCase<ID, R, E> {
    private final EventDispatcher eventDispatcher;

    public AbstractRestoreDeleteWithEventUseCase(R repository, EventDispatcher eventDispatcher) {
        super(repository);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    protected boolean execute(E entity) {
        entity.setDeleted(true);
        return repository.permanentDelete(entity.getId());
    }

    @Override
    protected final void after(E e) {
        eventDispatcher.dispatch(restoreEvent(e));
    }

    protected abstract AbstractEntityRestoreEvent<E> restoreEvent(E e);
}
