package ru.foodtechlab.abe.domain.usecase;

import com.rcore.domain.commons.port.ReadRepository;
import com.rcore.event.driven.EventDispatcher;
import ru.foodtechlab.abe.domain.entities.BaseDeleteEntity;
import ru.foodtechlab.abe.domain.events.AbstractEntityPermanentDeleteEvent;
import ru.foodtechlab.abe.domain.port.SafeDeleteRepository;
import ru.foodtechlab.abe.domain.port.SafeReadRepository;

public abstract class AbstractPermanentDeleteWithEventUseCase<ID, R extends ReadRepository<ID, E, ?> & SafeDeleteRepository<ID> & SafeReadRepository<ID, E, ?>, E extends BaseDeleteEntity<ID>> extends AbstractActionWithWithDeletedEntityUseCase<ID, R, E> {
    private final EventDispatcher eventDispatcher;

    public AbstractPermanentDeleteWithEventUseCase(R repository, EventDispatcher eventDispatcher) {
        super(repository);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    protected boolean execute(E entity) {
        entity.setDeleted(true);
        return repository.permanentDelete(entity.getId());
    }

    @Override
    protected final void after(E e) {
        eventDispatcher.dispatch(permanentDeleteEvent(e));
    }

    protected abstract AbstractEntityPermanentDeleteEvent<E> permanentDeleteEvent(E e);
}
