/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Objects;
import ru.foodtechlab.abe.core.entities.CountryCode;

public class PhoneNumber {
    protected String phoneNumber;
    protected CountryCode countryCode;
    protected String phoneNumberInternational;
    protected String phoneNumberE164;
    protected Boolean valid;

    public static String format(String value) {
        if (value == null) {
            return "";
        }
        Object formatted = value.replaceAll("[^0-9]", "");
        if (((String)formatted).startsWith("89")) {
            formatted = "7" + ((String)formatted).substring(1);
        }
        return formatted;
    }

    public static boolean isValid(String challenge) {
        try {
            String formattedValue = PhoneNumber.format(challenge);
            CountryCode countryCode = CountryCode.parse(formattedValue);
            PhoneNumberUtil pnu = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber pn = pnu.parse((CharSequence)formattedValue, countryCode.countryCode());
            pnu.format(pn, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
            pnu.format(pn, PhoneNumberUtil.PhoneNumberFormat.E164);
            return true;
        }
        catch (Exception _ignore) {
            return false;
        }
    }

    public void setPhoneNumber(String phoneNumber) {
        String formattedValue;
        this.phoneNumber = formattedValue = PhoneNumber.format(phoneNumber);
        try {
            this.countryCode = CountryCode.parse(formattedValue);
            PhoneNumberUtil pnu = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber pn = pnu.parse((CharSequence)formattedValue, this.countryCode.countryCode());
            this.phoneNumberInternational = pnu.format(pn, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
            this.phoneNumberE164 = pnu.format(pn, PhoneNumberUtil.PhoneNumberFormat.E164);
            this.valid = true;
        }
        catch (Exception _ignore) {
            this.valid = false;
            this.phoneNumberInternational = null;
            this.phoneNumberE164 = null;
        }
    }

    public static PhoneNumber of(String value) throws NumberParseException {
        if (value == null) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "PhoneNumber of exeption");
        }
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setPhoneNumber(value);
        if (!phoneNumber.valid.booleanValue()) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "PhoneNumber of exeption");
        }
        return phoneNumber;
    }

    public String toString() {
        return this.phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber that = (PhoneNumber)o;
        return Objects.equals(this.phoneNumber, that.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumber);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public String getPhoneNumberInternational() {
        return this.phoneNumberInternational;
    }

    public String getPhoneNumberE164() {
        return this.phoneNumberE164;
    }

    public Boolean getValid() {
        return this.valid;
    }
}

