/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

public class Location {
    private double latitude;
    private double longitude;

    public Location(double latitude, double longitude) {
        double d = latitude > 90.0 ? 90.0 : (this.latitude = latitude < -90.0 ? -90.0 : latitude);
        this.longitude = longitude > 180.0 ? 180.0 : (longitude < -180.0 ? -180.0 : longitude);
    }

    public static Location empty() {
        return new Location(0.0, 0.0);
    }

    public static Location of(double latitude, double longitude) {
        return new Location(latitude, longitude);
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Location() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        return Double.compare(this.getLongitude(), other.getLongitude()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        return result;
    }

    public static class Builder {
        public double longitude;
        public double latitude;

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Location build() {
            return Location.of(this.latitude, this.longitude);
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }
    }
}

